//
//  $Id: AHKUniqueNumberFormatter.m 98 2009-06-12 17:01:44Z fujidana $
//  Copyright (c) 2005-2009 Fujidana All rights reserved.
//
//
//  MemoryNumberFormatter.m
//  BookmarkUtility
//
//  Created by raktajino on Fri Jul 09 2004.
//  Copyright (c) 2004 raktajino. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "AHKUniqueNumberFormatter.h"
#import "AHKUniquelyNumberedArrayController.h"

@implementation AHKUniqueNumberFormatter

#pragma mark init and dealloc
- (id)initWithUniquelyNumberedArrayController:(AHKUniquelyNumberedArrayController *)anArrayController
{
    self = [super init];
    if (self)
	{
		arrayController = [anArrayController retain];
		[self setAllowsFloats:NO];
		[self setFormat:@"#;0;-#"];
		
		int minValue = [arrayController minValue];
		int maxValue = [arrayController maxValue];
		[self setMinimum:[NSDecimalNumber numberWithInt:minValue]];
		[self setMaximum:[NSDecimalNumber numberWithInt:maxValue]];
		
		[arrayController addObserver:self forKeyPath:@"minValue" options:NSKeyValueObservingOptionNew context:NULL];
		[arrayController addObserver:self forKeyPath:@"maxValue" options:NSKeyValueObservingOptionNew context:NULL];
	}
	return self;
}

- (void)dealloc
{
	[arrayController removeObserver:self forKeyPath:@"minValue"];
	[arrayController removeObserver:self forKeyPath:@"maxValue"];
	
	[arrayController release];
	arrayController = nil;
	
	
	[super dealloc];
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	if (object == arrayController && [keyPath isEqualToString:@"minValue"])
	{
		int minValue = [arrayController minValue];
		[self setMinimum:[NSDecimalNumber numberWithInt:minValue]];
	}
	else if (object == arrayController && [keyPath isEqualToString:@"maxValue"])
	{
		int maxValue = [arrayController maxValue];
		[self setMaximum:[NSDecimalNumber numberWithInt:maxValue]];
	}
}

#pragma mark override
- (BOOL)getObjectValue:(id *)obj forString:(NSString *)string errorDescription:(NSString **)error
{
	if ([super getObjectValue:obj forString:string errorDescription:error])
	{
		unsigned int row = [arrayController selectionIndex];
		if (row != NSNotFound)
		{
			id currentObject = [[arrayController arrangedObjects] objectAtIndex:row];
			if ([arrayController containsNumber:[string intValue] exceptObject:currentObject] == NO)
			{
				return YES;
			}
			else if (error)
			{
				*error = NSLocalizedString(@"The same memory number has been used.", @"AHKExclusiveNumberFomatter.error.existsSameNumber");
			}
		}
	}
	return NO;
}

@end
